package gov.va.vamf.scheduling.varutility.resource;


import gov.va.vamf.scheduling.varutility.domain.Institution;

import gov.va.vamf.scheduling.varutility.service.InstitutionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import java.util.ArrayList;
import java.util.List;

@Component
@Path("/institutions")
@Scope("request")
public class InstitutionResource {

    @Autowired
    InstitutionService institutionService;

    @GET
    @Path("/site/{site-code}")
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public List<Institution> fetchInstitutions(@PathParam("site-code") String siteCode) {

        List<Institution> institutions = institutionService.fetchInstitutionsBySiteCode(siteCode);

        if (institutions == null) {
            institutions = new ArrayList<Institution>();
        }

        return institutions;
    }
}
